/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.util.FileGrowingException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class DirectorySpy {
    private static final String TRACE_MASKT = "XPAFLIST";
    private static final String TRACE_MASKF = "XPAFLISF";
    private static final String TRACE_MASKD = "XPAFLISD";

    public static void main(String[] args) {
        int sampleInterval = 5;
        int loopCount = 12;
        int growCount = 4;
        File[] fileList = null;
        if (args.length > 0) {
            Integer value;
            String directory = args[0];
            if (args.length > 1) {
                value = new Integer(args[1]);
                sampleInterval = value;
            }
            if (args.length > 2) {
                value = new Integer(args[2]);
                loopCount = value;
            }
            if (args.length > 3) {
                value = new Integer(args[3]);
                growCount = value;
            }
            Trace.trace(TRACE_MASKD, "sampleInterval = " + sampleInterval);
            Trace.trace(TRACE_MASKD, "loopCount =" + loopCount);
            Trace.trace(TRACE_MASKD, "growCount =" + growCount);
            try {
                fileList = DirectorySpy.waitOn(new File(directory), sampleInterval, loopCount, growCount);
            }
            catch (FileGrowingException e) {
                Trace.trace(TRACE_MASKD, "the file was still growing when it timed out");
            }
            if (fileList != null && fileList.length != 0) {
                Trace.trace(TRACE_MASKD, "log the file names here");
                int i = 0;
                while (i < fileList.length) {
                    Trace.trace(TRACE_MASKD, "file [" + i + "]'s name is" + fileList[i].getAbsolutePath());
                    ++i;
                }
            }
        } else {
            System.out.println("you didn't specify the File to monitor");
        }
    }

    public DirectorySpy() {
        Trace.trace(TRACE_MASKF, "DirectorySpy.ctor()");
    }

    public static File[] waitOn(File file, int sampleTime, int waitCount, int growCount) throws FileGrowingException {
        return DirectorySpy.waitOn(file, null, sampleTime, waitCount, growCount);
    }

    public static File[] waitOn(File file, File[] inputList, int sampleTime, int waitCount, int growCount) throws FileGrowingException {
        File[] fileList = null;
        long fileLength = 0L;
        if (file != null) {
            if (file.isDirectory()) {
                File[] initFileList = null;
                initFileList = inputList != null ? inputList : file.listFiles();
                Trace.trace(TRACE_MASKD, "initFileList.length :" + initFileList.length);
                int i = 0;
                while (i < waitCount) {
                    try {
                        Thread.sleep(sampleTime * 1000);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    File[] newList = file.listFiles();
                    Trace.trace(TRACE_MASKD, "new length is" + newList.length);
                    fileList = DirectorySpy.compareList(initFileList, newList);
                    if (fileList.length != 0) {
                        Trace.trace(TRACE_MASKD, "got " + fileList.length + " new files.");
                        break;
                    }
                    Trace.trace(TRACE_MASKD, "no new files");
                    ++i;
                }
            } else {
                long fileIntialLength = 0L;
                boolean growing = false;
                int stopped = 0;
                Trace.trace(TRACE_MASKD, "waiting on file " + file.getAbsolutePath());
                int i = 0;
                while (i < waitCount) {
                    if (file.exists()) {
                        fileList = new File[]{file};
                        fileLength = file.length();
                        if (fileIntialLength < fileLength) {
                            growing = true;
                            Trace.trace(TRACE_MASKD, "file is growing");
                        } else {
                            growing = false;
                            Trace.trace(TRACE_MASKD, "file is isn't growing");
                            if (stopped == growCount) {
                                Trace.trace(TRACE_MASKD, "reached the grow count. Done.");
                                break;
                            }
                            ++stopped;
                        }
                    } else {
                        Trace.trace(TRACE_MASKD, "The file doesn't exist.");
                        if (fileList != null) {
                            fileList = null;
                        }
                    }
                    Trace.trace(TRACE_MASKD, "go to sleep");
                    try {
                        Thread.sleep(sampleTime * 1000);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
                Trace.trace(TRACE_MASKD, "end of wait loop");
                Trace.trace(TRACE_MASKD, "growing is " + growing);
                if (growing) {
                    throw new FileGrowingException("File was still growing");
                }
            }
        }
        if (fileList != null) {
            Trace.trace(TRACE_MASKD, "Returning " + fileList.length + " files");
        } else {
            Trace.trace(TRACE_MASKD, "Return no files");
        }
        return fileList;
    }

    private static void logFile(String theFile) {
    }

    private static File[] compareList(File[] list1, File[] list2) {
        ArrayList<File> arrayFileList = new ArrayList<File>();
        Trace.trace(TRACE_MASKD, "dump the files");
        Trace.trace(TRACE_MASKD, "length 1 is=" + list1.length);
        Trace.trace(TRACE_MASKD, "length 2 is=" + list2.length);
        boolean same = Arrays.equals(list1, list2);
        if (same) {
            Trace.trace(TRACE_MASKD, "the array are the same");
        } else {
            Trace.trace(TRACE_MASKD, "they are not");
            int fileFoundCount = 0;
            int i = list2.length - 1;
            while (i >= 0) {
                Trace.trace(TRACE_MASKD, "looking for file named " + list2[i]);
                File a = list2[i];
                boolean foundIt = false;
                int j = 0;
                while (j < list1.length) {
                    if (a.equals(list1[j])) {
                        foundIt = true;
                        break;
                    }
                    ++j;
                }
                if (!foundIt) {
                    Trace.trace(TRACE_MASKD, "didn't find the name " + list2[i]);
                    arrayFileList.add(a);
                    ++fileFoundCount;
                }
                foundIt = false;
                --i;
            }
        }
        Trace.trace(TRACE_MASKD, "returning " + arrayFileList.size() + " elements");
        return arrayFileList.toArray(new File[arrayFileList.size()]);
    }
}

